/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.ftb.log.LogEntry;
import net.ftb.log.LogSource;
import net.ftb.log.Logger;

public class StreamLogger
extends Thread {
    private final InputStream is;
    private final LogEntry logInfo;
    private String[] ignore;
    private static StreamLogger instance;

    private StreamLogger(InputStream from, LogEntry logInfo) {
        instance = this;
        this.is = from;
        this.logInfo = logInfo;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[4096];
        String logBuffer = "";
        try {
            while (this.is.read(buffer) > 0) {
                int newLineIndex;
                int nullIndex = (logBuffer = logBuffer + new String(buffer).replace("\r\n", "\n")).indexOf(0);
                if (nullIndex != -1) {
                    logBuffer = logBuffer.substring(0, nullIndex);
                }
                while ((newLineIndex = logBuffer.indexOf("\n")) != -1) {
                    if (this.ignore != null) {
                        boolean skip = false;
                        for (String s : this.ignore) {
                            if (!logBuffer.substring(0, newLineIndex).contains(s)) continue;
                            skip = true;
                        }
                        if (!skip) {
                            Logger.log(new LogEntry().copyInformation(this.logInfo).message(logBuffer.substring(0, newLineIndex)));
                        }
                    } else {
                        Logger.log(new LogEntry().copyInformation(this.logInfo).message(logBuffer.substring(0, newLineIndex)));
                    }
                    logBuffer = logBuffer.substring(newLineIndex + 1);
                }
                Arrays.fill(buffer, (byte)0);
            }
        }
        catch (IOException e) {
            Logger.logError("Error while reading log messages from external source(minecraft process)", e);
        }
    }

    public static void prepare(InputStream from, LogEntry logInfo) {
        logInfo.source(LogSource.EXTERNAL);
        instance = new StreamLogger(from, logInfo);
    }

    public static void doStart() {
        instance.start();
    }

    public static void setIgnore(String[] ignore) {
        StreamLogger.instance.ignore = ignore;
    }

    public static StreamLogger getInstance() {
        return instance;
    }
}

